<?php

namespace oms\userdb\repositories;

use yii\base\Component;
use oms\userapi\Client;
use oms\userdb\models\Model;
use oms\userdb\components\ApiDataProvider;

abstract class Repository extends Component
{
    /**
     *
     * @var Client
     */
    public $client;
    
    protected $modelClass;
    protected $endpoints = [];
    
    public function init()
    {
    }

    public function provider($expand = null)
    {
        $endpoint = $this->endpoints[__FUNCTION__];
        $params = array_merge(\Yii::$app->request->queryParams, ['expand' => $expand]);
        $response = $this->client->request('GET', $endpoint, $params)->json();
        return new ApiDataProvider($this->modelClass, $response);
    }
    
    public function view($id, $expand = null)
    {
        $endpoint = $this->endpoints[__FUNCTION__];
        $response = $this->client->request('GET', $endpoint, ['id' => $id, 'expand' => $expand])->json();
        return call_user_func([$this->modelClass, 'create'], $response);
    }
    
    public function create(Model $model)
    {
        $endpoint = $this->endpoints[__FUNCTION__];
        return $this->client->request('POST', $endpoint, $model->attributes)->json();
    }
    
    public function update(Model $model)
    {
        $endpoint = $this->endpoints[__FUNCTION__];
        return $this->client->request('POST', $endpoint . '?id=' . $model->id, $model->attributes)->json();
    }
    
        
    public function save(Model $model)
    {
        if ($model->id)
            return $this->update($model);
        else
            return $this->create($model);
    }
}
