<?php

namespace oms\userdb\models;

use common\components\UserGroupLinker;
use common\models\Permissions;
use oms\userdb\repositories\UserRepository;

/**
 * @property string $username
 * @property string $firstName
 * @property string $lastName
 * @property string $email
 * @property integer[] $groupIds
 * @property integer $role
 */
class UserForm extends FormModel
{
    /**
     * Return model attribute names that should be edited in this form.
     * @return string[]
     */
    protected function modelFields()
    {
        return [
            'username',
            'firstName',
            'lastName',
            'email',
            'groupIds',
            'role',
        ];
    }

    public function rules()
    {
        return [
            [['firstName', 'lastName'], 'string', 'max' => 32, 'tooLong' => 'Must be no more than 32 characters'],
        ];
    }
}
