<?php

namespace oms\userdb\components;

use yii\web\User as WebUser;
use oms\userdb\models\UserIdentity;

/**
 * @property UserIdentity $identity
 */
class User extends WebUser
{
    public function init()
    {
        if (!$this->identityClass)
            $this->identityClass = UserIdentity::className();
        
        parent::init();
    }
    
    public function can($permissionName, $params = [], $allowCaching = true)
    {
        return
            !$this->isGuest &&
            $this->identity->role >= $permissionName;
        
        //return parent::can($permissionName, $params, $allowCaching);
    }
    
    /**
     * Returns true if user is admin.
     * @return boolean
     */
    public function isAdmin()
    {
        return $this->can(UserIdentity::ROLE_ADMIN);
    }
    
    /**
     * Returns the identity object associated with the currently logged-in user.
     * When [[enableSession]] is true, this method may attempt to read the user's authentication data
     * stored in session and reconstruct the corresponding identity object, if it has not done so before.
     * @param boolean $autoRenew whether to automatically renew authentication status if it has not been done so before.
     * This is only useful when [[enableSession]] is true.
     * @return UserIdentity|null the identity object associated with the currently logged-in user.
     * `null` is returned if the user is not logged in (not authenticated).
     * @see login()
     * @see logout()
     */
    public function getIdentity($autoRenew = true)
    {
        return parent::getIdentity($autoRenew);
    }
}
