<?php

/* @var $this yii\web\View */
/* @var $form \yii\widgets\ActiveForm */
/* @var $model oms\userdb\models\LoginForm */
/* @var $resetPasswordUrl text */

use yii\helpers\Html;
use yii\bootstrap\ActiveForm;

$this->title = 'Login';
$this->params['breadcrumbs'][] = $this->title;

?>
<div class="sign-up-box">
    <?php $form = ActiveForm::begin(['id' => 'login-form']); ?>

    <?= $form->errorSummary($model) ?>

    <?= $form->field($model, 'username')->textInput(['placeholder' => 'Username'])->label(false) ?>

    <?= $form->field($model, 'password')->passwordInput(['placeholder' => 'Password', 'class'])->label(false) ?>

    <?= $form->field($model, 'rememberMe')->checkbox() ?>

    <?= Html::submitButton('Login', array('class' => 'btn btn-primary', 'style' => 'width: 100%')); ?>

    <div class="form-text">
        If you forgot your password you can
        <a href="<?= $resetPasswordUrl ?>">reset it</a>
        .
    </div>

    <?php ActiveForm::end(); ?>
</div>