<?php

use yii\helpers\Html;
use yii\grid\GridView;
use lo\modules\noty\Wrapper;

/* @var $this yii\web\View */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Users Access';
$this->params['breadcrumbs'][] = [
    'url' => ['index'],
    'label' => 'Users',
];
$this->params['breadcrumbs'][] = $this->title;

?>
<div class="user-index">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Create User', ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?php \yii\widgets\Pjax::begin();
    echo Wrapper::widget([
        'layerClass' => 'lo\modules\noty\layers\Noty'
    ]);
    ?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'columns' => [
            //['class' => 'yii\grid\SerialColumn'],

            'id',
            'username',
            //'auth_key',
            //'password_hash',
            //'password_reset_token',
            'email:email',
            'lastVisit',
            [
                'attribute'=>'hasPassword',
                'format' => 'boolean',
                'filter' => [1 => 'Yes', 2 => 'No']
            ],
            'lastEmailStatus',
            //'roleLabel',
            // 'created_at',
            // 'updated_at',

            ['class' => 'yii\grid\ActionColumn',
                'template' => '{view} {update} {resend-email}',
                'buttons' => [
                    'resend-email' => function ($url) {
                        $page = $this->context->actionParams['page'];
                        return Html::a(
                            '<span class="glyphicon glyphicon-repeat"></span>',
                            $url.'&page='.$page,
                            ['title'=> Yii::t('app', 'Resend Email'),'data-method'=>'post']//,'data-pjax'=>0]
                        );
                    }
                ],
            ],
        ],
    ]); ?>
    <?php yii\widgets\Pjax::end(); ?>

</div>
