<?php
namespace oms\userdb\controllers\frontend;

use Yii;
use yii\web\Controller;
use yii\filters\AccessControl;
use yii\authclient\InvalidResponseException;
use oms\userdb\Module;
use oms\userapi\UserApi;
use oms\userapi\LoginEndpoints;
use oms\userdb\models\UserIdentity;
use oms\userdb\models\LoginForm;

/**
 * Site controller
 * @property Module $module
 */
class AuthController extends Controller
{
    public $expand = null;
    
    /**
     * @var LoginEndpoints 
     */
    private $endpoints;


    public function __construct($id, $module, LoginEndpoints $endpoints, $config = array())
    {
        parent::__construct($id, $module, $config);
        
        $this->endpoints = $endpoints;
        
        $this->module->viewPath .= '/frontend';
    }

    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'only' => ['logout'],
                'rules' => [
                    [
                        'actions' => ['logout'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    public function actionLogin()
    {
        $model = new LoginForm();
        
        if ($model->load(\Yii::$app->request->post())) {
            $response = $this->endpoints->login($model->username, $model->password);
            
            $data = $response->json();
            
            if (isset($data['errors'])) {
                $model->addErrors($data['errors']);
                
            } else {
                $apiResponse = $this->module->client->request('GET', '/user/me', ['expand' => $this->expand])->json();
                
                $user = new UserIdentity();
                $user->setAttributes($apiResponse, false);
                Yii::$app->session->set('me', $apiResponse);
                Yii::$app->user->login($user, $model->rememberMe ? 3600 * 24 * 30 : 0);

                return $this->goBack();
            }
        }
        
        return $this->render('login', [
            'model' => $model,
            'resetPasswordUrl' => $this->module->loginOmsUrl . '/site/request-password-reset',
        ]);
    }
    
    /**
     * Logs out the current user.
     *
     * @return mixed
     */
    public function actionLogout()
    {
        if (Yii::$app->request->isPost)
            Yii::$app->user->logout();

        return $this->goHome();
    }
}
