<?php

namespace oms\userdb\controllers\backend;

use yii\filters\AccessControl;
use oms\userdb\models\User;

class Controller extends \yii\web\Controller
{
    public function __construct($id, $module, $config = array())
    {
        parent::__construct($id, $module, $config);
        
        $this->module->viewPath .= '/backend';
    }
    
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'roles' => [User::ROLE_ADMIN],
                    ],
                ],
            ],
        ];
    }
}
