<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use oms\userdb\enums\Role;
use oms\userdb\models\UserForm;
use oms\userdb\repositories\GroupRepository;
use oms\userdb\widgets\MultiSelect;

/* @var $this yii\web\View */
/* @var $model UserForm */
/* @var $form yii\widgets\ActiveForm */

$repository = Yii::$container->get(GroupRepository::className());
/* @var $repository GroupRepository */
$groups = $repository->provider()->models;
$groupVariants = ArrayHelper::map($groups, 'id', 'name');
?>

<div class="user-form">

    <?php $form = ActiveForm::begin(); ?>
    <?= $form->errorSummary($model); ?>
    <?= $form->field($model, 'username')->textInput(['autofocus' => true]) ?>
    <?= $form->field($model, 'firstName')->textInput() ?>
    <?= $form->field($model, 'lastName')->textInput() ?>
    <?= $form->field($model, 'email')->textInput(['type' => 'email']) ?>
    <?= $form->field($model, 'groupIds')->widget(MultiSelect::className(), ['items' => $groupVariants]) ?>
    <?= $form->field($model, 'role')->radioList(Role::labels()) ?>
    
    <?= $this->render('parts/form-end', ['model' => $model, 'form' => $form]) ?>

    <div class="form-group">
        <?= Html::submitButton($model->id ? 'Update' : 'Create', ['class' => $model->id ? 'btn btn-primary' : 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
