<?php

namespace oms\userdb\enums;

use CommerceGuys\Enum\AbstractEnum;

class Role extends AbstractEnum
{
    const GUEST = 0;
    const USER  = 5;
    const ADMIN = 10;
    
    public static function labels()
    {
        return [
            self::GUEST => 'Guest',
            self::USER => 'User',
            self::ADMIN => 'Admin',
        ];
    }
    
    public static function labelFor($value)
    {
        $labels = self::labels();
        return $labels[$value];
    }
}
