<?php

namespace oms\userdb\components\actions;

use Yii;
use yii\base\Action;
use oms\userdb\models\FormModel;
use yii\base\InvalidConfigException;

class FormAction extends Action
{
    public $formClass;
    public $repository;
    public $model;
    
    public function init()
    {
        parent::init();
        
        if (!$this->formClass)
            throw new InvalidConfigException(__CLASS__ . '::$formClass must be defined. ');
    }
    
    public function run($id = null)
    {
        $form = Yii::createObject($this->formClass, [$this->repository]);
        /* @var $model FormModel */
        $form->setModel(call_user_func($this->model, $id));

        if ($form->load(Yii::$app->request->post()) && $form->save()) {
            return $this->controller->redirect(['view', 'id' => $form->id]);
        }
        
        return $this->controller->render($this->id, [
            'model' => $form,
        ]);
    }
}
