<?php

namespace oms\userdb\repositories;

use oms\userdb\models\Group;

class GroupRepository extends Repository
{
    public function init()
    {
        $this->modelClass = Group::className();
        $this->endpoints = [
            'provider' => '/group/index',
            'view' => '/group/view',
            'create' => '/group/create',
            'update' => '/group/update',
        ];
        
        parent::init();
    }
    
    public function delete($id)
    {
        return $this->client->request('POST', '/group/delete?id=' . $id);
    }
}
