<?php

namespace oms\userdb\models;

use oms\userdb\enums\Role;
use oms\userdb\enums\Status;

/**
 * User model
 *
 * @property-read string roleLabel
 */
class User extends Model
{
    const STATUS_DELETED = 0;
    const STATUS_ACTIVE = 10;

    const ROLE_GUEST = 0;
    const ROLE_USER = 5;
    const ROLE_ADMIN = 10;
    const ROLE_SUPER_ADMIN = 15;

    # Fields #

    /**
     * @var integer
     */
    public $id;

    /**
     * @var string
     */
    public $username;

    /**
     * @var string
     */
    public $firstName;

    /**
     * @var string
     */
    public $lastName;

    /**
     * @var string
     */
    public $email;

    /**
     * @var integer
     */
    public $role;

    /**
     * @var integer
     */
    public $status;

    # Extra fields #

    /**
     * @var Group[]
     */
    public $groups;
    public $groupIds;
    public $isSuperadmin;
    public $passwordResetLink;
    public $passwordResetExpireTime;

    # Extra fields about access status #

    public $hasPassword;
    public $lastEmailStatus;
    public $lastVisit;
    public $loginAttempts;

    /**
     * @inheritdoc
     */
    public static function create($data)
    {
        $model = parent::create($data);
        if (isset($data['groups'])) {
            $model->groups = Group::createAll($data['groups']);
        }
        return $model;
    }

    public function scenarios()
    {
        return [
                'default' => ['username', 'firstName', 'lastName', 'email', 'groupIds'],
            ] + parent::scenarios();
    }

    public function attributeLabels()
    {
        return [
            'roleLabel' => 'Role',
            'statusLabel' => 'Status',
        ];
    }

    public function getRoleLabel()
    {
        return Role::labelFor($this->role);
    }

    public function getStatusLabel()
    {
        return Status::labelFor($this->status);
    }
}
