<?php

namespace oms\userdb\models;

use oms\userdb\repositories\Repository;
use yii\base\NotSupportedException;

/**
 * @property Model $model
 * @property-read integer $id
 */
class FormModel extends Model
{
    /**
     * Connected model
     * @var Model
     */
    protected $_model;
    
    /**
     * Model attributes data on form
     * @var type 
     */
    private $_modelAttributes = [];
    
    /**
     * @var Repository
     */
    private $repository;
    
    public function __construct(Repository $repository, $config = array())
    {
        parent::__construct($config);
        
        $this->repository = $repository;
    }
    
    public function __isset($name)
    {
        return in_array($name, $this->modelFields()) || parent::__isset($name);
    }
    
    public function __get($name)
    {
        if (in_array($name, $this->modelFields())) {
            return isset($this->_modelAttributes[$name]) ? $this->_modelAttributes[$name] : null;
        } else {
            return parent::__get($name);
        }
    }
    
    public function __set($name, $value)
    {
        if (in_array($name, $this->modelFields())) {
            $this->_modelAttributes[$name] = $value;
        } else {
            parent::__set($name, $value);
        }
    }
    
    public function rules()
    {
        return [
            [$this->modelFields(), 'safe'],
            ['model', 'validateModel'],
        ];
    }
    
    public function validateModel()
    {
        $model = $this->_model;
        
        $model->setAttributes($this->_modelAttributes, false);
        
        if (!$model->validate())
            $this->addErrors($model->getErrors());
    }
    
    /**
     * Return model attribute names that should be edited in this form.
     * @return string[]
     */
    protected function modelFields()
    {
        return [];
    }
    
    public function save()
    {
        if (!$this->validate())
            return false;
        
        $response = $this->repository->save($this->_model);
            
        if (isset($response['validationErrors'])) {
            $this->addErrors($response['validationErrors']);
            return false;

        } elseif (isset($response['id'])) {
            $this->_model->id = $response['id'];
            return true;

        } else {
            throw new NotSupportedException('Unknown response: ' . json_encode($response));
        }
    }
    
    public function getId()
    {
        return $this->_model->id;
    }
    
    /**
     * 
     * @return Model
     */
    public function getModel()
    {
        return $this->_model;
    }
    
    /**
     * 
     * @param Model $model
     */
    public function setModel($model)
    {
        $this->_model = $model;
        $this->_modelAttributes = $model->getAttributes($this->modelFields());
    }
}
