<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model oms\userdb\models\User */

$this->title = $model->username;
$this->params['breadcrumbs'][] = ['url' => ['index'], 'label' => 'Users'];
$this->params['breadcrumbs'][] = $this->title;

// Render "Groups" field
$groupLinks = [];
foreach ($model->groups as $group) {
    $groupLinks[] = Html::a($group->name, ['group/view', 'id' => $group->id]);
}

// Render "Password Reset Link" field
$passwordResetLink = Html::a($model->passwordResetLink, $model->passwordResetLink) . '<br/>' .
    'Expires in ' . Yii::$app->formatter->asDuration($model->passwordResetExpireTime - time()) . '. ' .
    Html::a('Refresh', ['refresh-token', 'id' => $model->id]);

?>

<h1><?= Html::encode($this->title) ?></h1>

<p>
    <?= Html::a('Update', ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
</p>

<?= DetailView::widget([
    'model' => $model,
    'attributes' => [
        'username',
        'firstName',
        'lastName',
        'email:email',
        'roleLabel',
        [
            'attribute' => 'groups',
            'format' => 'raw',
            'value' => implode('<br/>', $groupLinks),
        ],
        [
            'attribute' => 'passwordResetLink',
            'format' => 'raw',
            'value' => $passwordResetLink,
        ],
    ],
]) ?>

<?= $this->render('parts/view-end', ['model' => $model]) ?>
