<?php

namespace oms\userdb;

use Yii;
use oms\userapi\UserApi;
use oms\userapi\Client;
use oms\userapi\LoginEndpoints;
use oms\userdb\components\Api;
use oms\userdb\repositories\UserRepository;
use oms\userdb\repositories\GroupRepository;
use yii\di\Instance;

/**
 * 
 * Requirements
 * guzzlehttp/guzzle "~6.2"
 * 
 * @property-read Api $api
 */
class Module extends \yii\base\Module
{
    public $controllerNamespace = 'oms\userdb\controllers\backend';
    
    public $userApiConfig = [];

    public $loginOmsUrl = 'https://pprodlogin.oms.center';

    /**
     *
     * @var Client 
     */
    public $client;

    public function init()
    {
        parent::init();
        
        UserApi::configure($this->userApiConfig);

        
        $this->client = UserApi::createClient();
        
        \Yii::$container->set(LoginEndpoints::class, function () {
            return UserApi::createLoginEndpoints($this->client);
        });
        \Yii::$container->setSingleton(UserRepository::className(), [
            'client' => $this->client,
        ]);
        \Yii::$container->setSingleton(GroupRepository::className(), [
            'client' => $this->client,
        ]);
    }
}
