<?php

namespace oms\userdb\models;

class Group extends Model
{
    public $id;
    public $name;
    /**
     * @var User[]
     */
    public $users;
    public $userIds;
    
    
    /**
     * @inheritdoc
     */
    public static function create($data)
    {
        $model = parent::create($data);
        $model->users = User::createAll(isset($data['users']) ? $data['users'] : []);
        return $model;
    }

    public function scenarios()
    {
        return [
            'create' => ['name', 'userIds'],
            'update' => ['name', 'userIds'],
        ] + parent::scenarios();
    }

    /**
     * @return integer[]
     */
    public function userIds()
    {
        $ids = [];
        foreach ($this->users as $user) {
            $ids[] = (int) $user->id;
        }
        return $ids;
    }
    
    /**
     * @return string[]
     */
    public function usernames()
    {
        $names = [];
        foreach ($this->users as $user) {
            $names[(int) $user->id] = $user->username;
        }
        return $names;
    }
}
