<?php

namespace oms\userdb\repositories;

use oms\userdb\models\User;

class UserRepository extends Repository
{
    public function init()
    {
        $this->modelClass = User::className();
        $this->endpoints = [
            'provider' => '/user/index',
            'view' => '/user/view',
            'create' => '/user/create',
            'update' => '/user/update',
        ];
        
        parent::init();
    }
    
    public function map()
    {
        return $this->client->request('GET', '/user/map', [])->json();
    }

    /**
     * Send new email to user with 'Password Reset Request Form'.
     * @param integer $id user id
     * @return array API response
     */
    public function resendEmail($id)
    {
        return $this->client->request('POST', '/user/resend-email?id=' . $id)->json();
    }

    /**
     * Refreshes user password reset token.
     * @param integer $id user id
     * @return array API response
     */
    public function refreshToken($id)
    {
        return $this->client->request('POST', '/user/refresh-token?id=' . $id)->json();
    }
}
