<?php

namespace oms\userdb\repositories;

use oms\userdb\models\User;

class UserRepository extends Repository
{
    public function init()
    {
        $this->modelClass = User::className();
        $this->endpoints = [
            'provider' => 'list-users',
            'view' => 'view-user',
            'create' => 'create-user',
            'update' => 'update-user',
        ];
        
        parent::init();
    }
    
    public function map()
    {
        return $this->client->api('users-map', 'GET', []);
    }

    /**
     * Send new email to user with 'Password Reset Request Form'.
     * @param integer $id user id
     * @return array API response
     */
    public function resendEmail($id)
    {
        return $this->client->api('resend-email-to-user?id=' . $id, 'POST');
    }

    /**
     * Refreshes user password reset token.
     * @param integer $id user id
     * @return array API response
     */
    public function refreshToken($id)
    {
        return $this->client->api('refresh-user-token?id=' . $id, 'POST');
    }
}
