<?php

namespace oms\userdb\repositories;

use yii\base\Component;
use yii\authclient\OAuth2;
use oms\userdb\models\Model;
use oms\userdb\components\ApiDataProvider;

abstract class Repository extends Component
{
    /**
     *
     * @var OAuth2
     */
    public $client;
    
    protected $modelClass;
    protected $endpoints = [];
    
    public function init()
    {
    }
    
    public function provider($page = null, $expand = null)
    {
        $endpoint = $this->endpoints[__FUNCTION__];
        $response = $this->client->api($endpoint, 'GET', ['page' => $page, 'expand' => $expand]);
        return new ApiDataProvider($this->modelClass, $response);
    }
    
    public function view($id, $expand = null)
    {
        $endpoint = $this->endpoints[__FUNCTION__];
        $response = $this->client->api($endpoint, 'GET', ['id' => $id, 'expand' => $expand]);
        return call_user_func([$this->modelClass, 'create'], $response);
    }
    
    public function create(Model $model)
    {
        $endpoint = $this->endpoints[__FUNCTION__];
        return $this->client->api($endpoint, 'POST', $model->attributes);
    }
    
    public function update(Model $model)
    {
        $endpoint = $this->endpoints[__FUNCTION__];
        return $this->client->api($endpoint . '?id=' . $model->id, 'POST', $model->attributes);
    }
    
        
    public function save(Model $model)
    {
        if ($model->id)
            return $this->update($model);
        else
            return $this->create($model);
    }
}
