<?php

namespace oms\userdb\repositories;

use oms\userdb\models\Group;

class GroupRepository extends Repository
{
    public function init()
    {
        $this->modelClass = Group::className();
        $this->endpoints = [
            'provider' => 'groups',
            'view' => 'view-group',
            'create' => 'create-group',
            'update' => 'update-group',
        ];
        
        parent::init();
    }
    
    public function delete($id)
    {
        return $this->client->api('delete-group?id=' . $id, 'POST');
    }
}
