<?php

namespace oms\userdb\repositories;

use oms\userdb\models\User;

class UserRepository extends Repository
{
    public function init()
    {
        $this->modelClass = User::className();
        $this->endpoints = [
            'provider' => 'list-users',
            'view' => 'view-user',
            'create' => 'create-user',
            'update' => 'update-user',
        ];
        
        parent::init();
    }
    
    public function map()
    {
        return $this->client->api('users-map', 'GET', []);
    }

    public function resendEmail($id)
    {
        return $this->client->api('resend-email-to-user', 'GET', ['id' => $id]);
    }
}
