<?php
namespace oms\userdb\controllers;

use Yii;
use yii\web\Controller;
use yii\filters\VerbFilter;
use yii\filters\AccessControl;

use yii\authclient\OAuth2;
use yii\authclient\InvalidResponseException;
use oms\userdb\models\UserIdentity;

/**
 * Site controller
 */
class AuthController extends Controller
{
    public $client = 'loginoms';
    public $expand = null;
    
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'only' => ['logout'],
                'rules' => [
                    [
                        'actions' => ['logout'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    public function actionLogin($code = null)
    {
        $oauthClient = Yii::$app->{$this->client};
        /* @var $oauthClient OAuth2 */
        
        if (!isset($code)) {

            $url = $oauthClient->buildAuthUrl(); // Build authorization URL
            return $this->redirect($url);
            
        } else {
            try {
                $accessToken = $oauthClient->fetchAccessToken($code); // Get access token
            } catch (InvalidResponseException $exc) {
                return $this->goHome();
            }
            
            $apiResponse = $oauthClient->api('index', 'GET', ['expand' => $this->expand]);
            
            $user = new UserIdentity();
            $user->setAttributes($apiResponse, false);
            Yii::$app->session->set('me', $apiResponse);
            Yii::$app->user->login($user);
            
            return $this->goBack();
        }
    }
    
    /**
     * Logs out the current user.
     *
     * @return mixed
     */
    public function actionLogout()
    {
        if (Yii::$app->request->isPost)
            Yii::$app->user->logout();

        return $this->goHome();
    }
}
