<?php

namespace oms\userdb;

use Yii;
use oms\userdb\components\Api;
use oms\userdb\repositories\UserRepository;
use oms\userdb\repositories\GroupRepository;
use yii\di\Instance;
use yii\authclient\OAuth2;

/**
 * 
 * Requirements
 * guzzlehttp/guzzle "~6.2"
 * 
 * @property-read Api $api
 */
class Module extends \yii\base\Module
{
    public $controllerNamespace = 'oms\userdb\controllers';
    
    /**
     *
     * @var OAuth2 
     */
    public $client;

    public function init()
    {
        parent::init();
        
        $this->client = Instance::ensure($this->client, Oauth2::className());
        
        \Yii::$container->setSingleton(UserRepository::className(), [
            'client' => $this->client,
        ]);
        \Yii::$container->setSingleton(GroupRepository::className(), [
            'client' => $this->client,
        ]);
    }
}
