<?php

namespace oms\userdb\models;

use common\components\UserGroupLinker;
use common\models\Permissions;
use oms\userdb\repositories\UserRepository;

class UserForm extends FormModel
{
    public $username;
    public $email;
    public $groupIds;
    public $role;
    
    public function rules()
    {
        return [
            [['username', 'email', 'groupIds', 'role'], 'safe'],
            ['model', 'validateUser'],
        ];
    }
    
    public function validateUser()
    {
        $model = $this->_model;
        
        $model->username = $this->username;
        $model->email = $this->email;
        $model->groupIds = $this->groupIds;
        $model->role = $this->role;
        
        if (!$model->validate())
            $this->addErrors($model->getErrors());
    }
    
    public function setModel($model)
    {
        parent::setModel($model);
        
        $this->username = $model->username;
        $this->email = $model->email;
        $this->groupIds = $model->groupIds;
        $this->role = $model->role;
    }
}
