<?php
namespace oms\userdb\models;

class GroupForm extends FormModel
{
    public $name;
    public $userIds;
    
    public function rules()
    {
        return [
            [['name', 'userIds'], 'safe'],
            ['model', 'validateGroup'],
        ];
    }
    
    public function validateGroup()
    {
        $model = $this->_model;
        
        $model->name = $this->name;
        $model->userIds = $this->userIds;
        
        if (!$model->validate())
            $this->addErrors($model->getErrors());
    }
    
    public function setModel($model)
    {
        parent::setModel($model);
        
        $this->name = $model->name;
        $this->userIds = $model->userIds;
    }
}
