<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model oms\userdb\models\User */

$this->title = $model->username;
$this->params['breadcrumbs'][] = ['url' => ['index'], 'label' => 'Users'];
$this->params['breadcrumbs'][] = $this->title;

$groupLinks = [];
foreach ($model->groups as $group) {
    $groupLinks[] = Html::a($group->name, ['group/view', 'id' => $group->id]);
}

?>

<h1><?= Html::encode($this->title) ?></h1>

<p>
    <?= Html::a('Update', ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
</p>

<?= DetailView::widget([
    'model' => $model,
    'attributes' => [
        'username',
        'email:email',
        'role',
        [
            'attribute' => 'groups',
            'format' => 'raw',
            'value' => implode('<br/>', $groupLinks),
        ],
    ],
]) ?>

<?= $this->render('parts/view-end', ['model' => $model]) ?>
