<?php

namespace oms\userdb\models;

use oms\userdb\repositories\Repository;
use yii\base\NotSupportedException;

/**
 * @property Model $model
 * @property-read integer $id
 */
class FormModel extends Model
{
    /**
     * Connected model
     * @var Model
     */
    protected $_model;
    
    /**
     * @var Repository
     */
    private $repository;
    
    public function __construct(Repository $repository, $config = array())
    {
        parent::__construct($config);
        
        $this->repository = $repository;
    }
    
    public function rules()
    {
        return [
        ];
    }
    
    public function save()
    {
        if (!$this->validate())
            return false;
        
        $response = $this->repository->save($this->_model);
            
        if (isset($response['validationErrors'])) {
            $this->addErrors($response['validationErrors']);
            return false;

        } elseif (isset($response['id'])) {
            $this->_model->id = $response['id'];
            return true;

        } else {
            throw new NotSupportedException('Unknown response: ' . json_encode($response));
        }
    }
    
    public function getId()
    {
        return $this->_model->id;
    }
    
    /**
     * 
     * @return Model
     */
    public function getModel()
    {
        return $this->_model;
    }
    
    /**
     * 
     * @param Model $model
     */
    public function setModel($model)
    {
        $this->_model = $model;
    }
}
