<?php

namespace oms\userdb\controllers;

use Yii;
use oms\userdb\models\User;
use oms\userdb\repositories\Repository;
use oms\userdb\repositories\UserRepository;
use oms\userdb\components\actions\FormAction;
use oms\userdb\models\UserForm;

class UserController extends Controller
{
    protected $repository;

    public function __construct($id, $module, UserRepository $repository, $config = [])
    {
        parent::__construct($id, $module, $config);
        
        $this->repository = $repository;
    }
    
    public function actions()
    {
        $formAction = [
            'class' => FormAction::className(),
            'formClass' => UserForm::className(),
            'repository' => $this->repository,
        ];
        
        return [
            'create' => $formAction + [
                'model' => function () {
                    return new User();
                },
            ],
            'update' => $formAction + [
                'model' => function ($id) {
                    return $this->findModel($id, 'groupIds');
                },
            ],
        ];
    }
    
    
    /**
     * Lists all User models.
     * @return mixed
     */
    public function actionIndex($page = null)
    {
        $dataProvider = $this->repository->provider($page);

        return $this->render('index', [
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single User model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id, 'groups'),
        ]);
    }

    /**
     * Deletes an existing User model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    /*public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }*/

    /**
     * Finds the User model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return User the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id, $fields = null)
    {
        $model = $this->repository->view($id, $fields);
        
        if ($model) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
