<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use oms\userdb\models\UserForm;
use oms\userdb\repositories\GroupRepository;

/* @var $this yii\web\View */
/* @var $model UserForm */
/* @var $form yii\widgets\ActiveForm */

$repository = Yii::$container->get(GroupRepository::className());
/* @var $repository GroupRepository */
$groups = $repository->provider()->models;
$groupVariants = ArrayHelper::map($groups, 'id', 'name');
?>

<div class="user-form">

    <?php $form = ActiveForm::begin(); ?>
    <?= $form->errorSummary($model); ?>
    <?= $form->field($model, 'username')->textInput(['autofocus' => true]) ?>
    <?= $form->field($model, 'email')->textInput(['type' => 'email']) ?>
    <?= $form->field($model, 'groupIds')->checkboxList($groupVariants) ?>
    
    <?= $this->render('parts/form-end', ['model' => $model, 'form' => $form]) ?>

    <div class="form-group">
        <?= Html::submitButton($model->user->id ? 'Update' : 'Create', ['class' => $model->user->id ? 'btn btn-primary' : 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
