<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\data\ArrayDataProvider;
use oms\userdb\models\User;


/* @var $this yii\web\View */
/* @var $model oms\userdb\models\Group */

$this->title = $model->name;
$this->params['breadcrumbs'][] = ['label' => 'Groups', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;

?>
<h1>Group: <?= Html::encode($this->title) ?></h1>

<p>
    <?= Html::a('Update', ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
    <?= Html::a('Delete', ['delete', 'id' => $model->id], [
        'class' => 'btn btn-danger',
        'data' => [
            'confirm' => 'Are you sure you want to delete this item?',
            'method' => 'post',
        ],
    ]) ?>
</p>

<div class="form-group">
    <label class="control-label">Users in group:</label>
    <?= GridView::widget([
        'dataProvider' => new ArrayDataProvider(['allModels' => $model->users, 'pagination' => false]),
        'columns' => [
            [
                'attribute' => 'username',
                'format' => 'raw',
                'value' => function (User $user) {
                    return Html::a($user->username, ['user/view', 'id' => $user->id]);
                },
            ],
            /*[
                'class' => 'yii\grid\ActionColumn',
                'buttons' => [
                ],
                'template'=>'{delete}',
            ],*/
        ],
    ]); ?>

</div>

<?= $this->render('parts/view-end', ['model' => $model]) ?>
