<?php

namespace oms\userdb\repositories;

use Yii;
use yii\base\Component;
use yii\di\Instance;
use oms\userdb\components\Api;
use yii\authclient\OAuth2;
use oms\userdb\models\User;
use oms\userdb\components\ApiDataProvider;

class UserRepository extends Component
{
    /**
     *
     * @var OAuth2
     */
    public $client;
    
    public function init()
    {
    }
    
    public function provider()
    {
        $response = $this->client->api('list-users', 'GET', []);
        return new ApiDataProvider(User::className(), $response);
    }
    
    public function map()
    {
        return $this->client->api('users-map', 'GET', []);
    }
    
    public function view($id, $expand = null)
    {
        $response = $this->client->api('view-user', 'GET', ['id' => $id, 'expand' => $expand]);
        return User::create($response);
    }
    
    public function create(User $model)
    {
        return $this->client->api('create-user', 'POST', $model->attributes);
    }
    
    public function update(User $model)
    {
        return $this->client->api('update-user?id=' . $model->id, 'POST', $model->attributes);
    }
    
    public function save(User $model)
    {
        if ($model->id)
            return $this->update($model);
        else
            return $this->create($model);
    }
}
