<?php

namespace oms\userdb\models;

use yii\base\Model;
use common\components\UserGroupLinker;
use common\models\Permissions;
use oms\userdb\repositories\UserRepository;

/**
 * @property User $user
 */
class UserForm extends Model
{
    /**
     * Connected user model
     * @var User
     */
    private $_user;
    
    public $username;
    public $email;
    
    public $groupIds;
    
    private $repository;
    
    public function __construct(UserRepository $repository, $config = array())
    {
        parent::__construct($config);
        
        $this->repository = $repository;
    }
    
    public function rules()
    {
        return [
            [['username', 'email', 'groupIds'], 'safe'],
            ['user', 'validateUser'],
            
            //['groupIds', 'default', 'value' => [], 'when' => function ($model) {return $model->groupIds === '';}],
            //['groupIds', 'each', 'rule' => ['integer']],
        ];
    }
    
    public function validateUser()
    {
        $model = $this->_user;
        
        $model->username = $this->username;
        $model->email = $this->email;
        
        if (!$model->validate())
            $this->addErrors($model->getErrors());
    }
    
    public function save()
    {
        if (!$this->validate())
            return false;
        
        $response = $this->repository->save($this->_user);
            
        if (isset($response['validationErrors'])) {
            $this->addErrors($response['validationErrors']);
            return false;

        } elseif (isset($response['id'])) {
            $this->_user->id = $response['id'];
            return true;

        } else {
            throw new NotSupportedException('Unknown response: ' . json_decode($response));
        }
    }
    
    public function getId()
    {
        return $this->_user->id;
    }
    
    /**
     * 
     * @return User
     */
    public function getUser()
    {
        return $this->_user;
    }
    
    /**
     * 
     * @param User $user
     */
    public function setUser($user)
    {
        $this->_user = $user;
        $this->username = $user->username;
        $this->email = $user->email;
        $this->groupIds = $user->groupIds;
    }
}
