<?php

namespace oms\userdb\models;

/**
 * User model
 */
class User extends Model
{
    const STATUS_DELETED = 0;
    const STATUS_ACTIVE = 10;

    const ROLE_USER = 0;
    const ROLE_ADMIN = 10;
    const ROLE_SUPER_ADMIN = 15;
    
    /**
     * @var integer
     */
    public $id;
    /**
     * @var string
     */
    public $username;
    /**
     * @var string
     */
    public $email;
    /**
     * @var integer
     */
    public $role;
    /**
     * @var Group[]
     */
    public $groups;
    public $groupIds;
    
    /**
     * @inheritdoc
     */
    public static function create($data)
    {
        $model = parent::create($data);
        if (isset($data['groups']))
            $model->groups = Group::createAll($data['groups']);
        return $model;
    }
    
    public function scenarios()
    {
        return [
            'default' => ['username', 'email', 'groupIds'],
        ] + parent::scenarios();
    }
}
