<?php

namespace oms\userdb\controllers;

use Yii;
use oms\userdb\models\Group;
use oms\userdb\repositories\GroupRepository;

class GroupController extends Controller
{
    protected $repository;
    
    public function __construct($id, $module, GroupRepository $repository, $config = [])
    {
        $this->repository = $repository;
        parent::__construct($id, $module, $config);
    }
    
    
    /**
     * Lists all Group models.
     * @return mixed
     */
    public function actionIndex()
    {
        $dataProvider = $this->repository->provider();

        return $this->render('index', [
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single User model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->repository->view($id, 'users'),
        ]);
    }

    /**
     * Creates a new User model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Group();
        $model->scenario = 'create';

        if ($model->load(Yii::$app->request->post())) {
            $response = $this->repository->create($model);
            
            if (isset($response['id'])) {
                $this->redirect(['view', 'id' => $response['id']]);
                
            } elseif (isset($response['validationErrors'])) {
                $model->addErrors($response['validationErrors']);
                
            } else {
                throw new NotSupportedException('Unknown response: ' . json_decode($response));
            }
        }
        
        return $this->render($this->action->id, [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing User model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $model = $this->repository->view($id, 'userIds');
        $model->scenario = 'update';

        if ($model->load(Yii::$app->request->post())) {
            $response = $this->repository->update($model);
            
            if (isset($response['id'])) {
                $this->redirect(['view', 'id' => $response['id']]);
                
            } elseif (isset($response['validationErrors'])) {
                $model->addErrors($response['validationErrors']);
                
            } else {
                throw new NotSupportedException('Unknown response: ' . json_decode($response));
            }
        }
            
        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing User model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {
        $this->repository->delete($id);

        return $this->redirect(['index']);
    }
}
