<?php

namespace oms\userdb\components\actions;

use Yii;
use yii\base\Action;
use oms\userdb\models\UserForm;

class UserFormAction extends Action
{
    private $form;
    
    public $userModel;
    
    public function __construct($id, $controller, UserForm $form, $config = array())
    {
        parent::__construct($id, $controller, $config);
        
        $this->form = $form;
    }
    
    public function run($id = null)
    {
        $model = Yii::createObject(UserForm::className());
        /* @var $model UserForm */
        $model->user = call_user_func($this->userModel, $id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->controller->redirect(['view', 'id' => $model->user->id]);
        }
        
        return $this->controller->render($this->id, [
            'model' => $model,
        ]);
    }
}
