<?php

namespace oms\userdb\components;

use yii\data\BaseDataProvider;
use oms\userdb\models\Model;

class ApiDataProvider extends BaseDataProvider
{
    private $_models;
    private $_totalCount;
    
    public function __construct($modelClass, $response)
    {
        $this->_totalCount = count($response);
        
        $this->_models = call_user_func([$modelClass, 'createAll'], $response);
    }
    
    /**
     * Prepares the data models that will be made available in the current page.
     * @return array the available data models
     */
    protected function prepareModels()
    {
        return $this->_models;
    }

    /**
     * Prepares the keys associated with the currently available data models.
     * @param array $models the available data models
     * @return array the keys
     */
    protected function prepareKeys($models)
    {
        return array_map(function(Model $model){
            return $model->id;
        }, $models);
    }

    /**
     * Returns a value indicating the total number of data models in this data provider.
     * @return integer total number of data models in this data provider.
     */
    protected function prepareTotalCount()
    {
        return $this->_totalCount;
    }
}
