<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model oms\userdb\models\User */

$this->title = $model->username;
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="user-view">

    <h1><?= Html::encode($this->title.' profile') ?></h1>

    <p>
        <?= Html::a('Update', ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Delete', ['delete', 'id' => $model->id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Are you sure you want to delete this item?',
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            //'id',
            'username',
            //'password_hash',
            //'password_reset_token',
            'email:email',
            //'role',
            /*[
                'attribute'=> 'role',
                'format'=>'raw',
                'value' => function ($data){
                    $role = '';
                    if($data->role == \common\models\User::ROLE_SUPER_ADMIN){
                        $role = 'Super Admin';}
                    elseif ($data->role == \common\models\User::ROLE_ADMIN){
                        $role = 'Admin';}
                    elseif ($data->role == \common\models\User::ROLE_USER){
                        $role = 'User';}
                    return $role;
                }
            ],*/
            //'created_at',
            //'updated_at',
        ],
    ]) ?>

</div>
