<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use oms\userdb\models\User;
use oms\userdb\repositories\GroupRepository;

/* @var $this yii\web\View */
/* @var $model User */
/* @var $form yii\widgets\ActiveForm */

$repository = Yii::$container->get(GroupRepository::className());
/* @var $repository GroupRepository */
$groups = $repository->provider()->models;
$groupVariants = ArrayHelper::map($groups, 'id', 'name');
?>

<div class="user-form">

    <?php $form = ActiveForm::begin(); ?>
    <?= $form->errorSummary($model); ?>
    <?= $form->field($model, 'username')->textInput(['autofocus' => true]) ?>
    <?= $form->field($model, 'email')->textInput(['type' => 'email']) ?>
    <?= $form->field($model, 'groupIds')->checkboxList($groupVariants) ?>

    <div class="form-group">
        <?= Html::submitButton($model->id ? 'Update' : 'Create', ['class' => $model->id ? 'btn btn-primary' : 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
