<?php

use yii\helpers\Html;
use yii\grid\GridView;
use kartik\typeahead\Typeahead;
use \yii\helpers\BaseUrl;
use \common\models\User;
use \yii\helpers\Url;
use yii\data\ArrayDataProvider;
use oms\userdb\models\Group;


/* @var $this yii\web\View */
/* @var $model Group */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = $model->name;
$this->params['breadcrumbs'][] = ['label' => 'Groups', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;

?>
<div class="group-view">

    <h1>Group: <?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Update', ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Delete', ['delete', 'id' => $model->id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Are you sure you want to delete this item?',
                'method' => 'post',
            ],
        ]) ?>
    </p>
    <div class="form-group">
        <label class="control-label">Users in group:</label>
    <?= GridView::widget([
        'dataProvider' => new ArrayDataProvider(['allModels' => $model->users, 'pagination' => false]),
        'columns' => [
            'username',
            /*[
                'class' => 'yii\grid\ActionColumn',
                'buttons' => [
                ],
                'template'=>'{delete}',
            ],*/
        ],
    ]); ?>

    </div>
</div>
