<?php

namespace oms\userdb\repositories;

use Yii;
use yii\base\Component;
use yii\di\Instance;
use oms\userdb\components\Api;
use yii\authclient\OAuth2;
use oms\userdb\models\Group;
use oms\userdb\components\ApiDataProvider;

class GroupRepository extends Component
{
    /**
     *
     * @var OAuth2
     */
    public $client;
    
    public function init()
    {
    }
    
    public function provider()
    {
        $response = $this->client->api('groups', 'GET', []);
        return new ApiDataProvider(Group::className(), $response);
    }
    
    public function view($id, $expand = null)
    {
        $response = $this->client->api('view-group', 'GET', ['id' => $id, 'expand' => $expand]);
        return Group::create($response);
    }
    
    public function create(Group $model)
    {
        return $this->client->api('create-group', 'POST', $model->attributes);
    }
    
    public function update(Group $model)
    {
        return $this->client->api('update-group?id=' . $model->id, 'POST', $model->attributes);
    }
    
    public function delete($id)
    {
        return $this->client->api('delete-group?id=' . $id, 'POST');
    }
}
