<?php

namespace oms\userdb\controllers;

use Yii;
use oms\userdb\models\User;
use oms\userdb\repositories\UserRepository;

class UserController extends Controller
{
    protected $repository;

    public function __construct($id, $module, UserRepository $repository, $config = [])
    {
        $this->repository = $repository;
        parent::__construct($id, $module, $config);
    }
    
    
    /**
     * Lists all User models.
     * @return mixed
     */
    public function actionIndex()
    {
        $dataProvider = $this->repository->provider();

        return $this->render('index', [
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single User model.
     * @param integer $id
     * @return mixed
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id, 'groups'),
        ]);
    }

    /**
     * Creates a new User model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new User();
        $model->scenario = 'create';

        if ($model->load(Yii::$app->request->post())) {
            $response = $this->repository->create($model);
            
            if (isset($response['id'])) {
                $this->redirect(['view', 'id' => $response['id']]);
                
            } elseif (isset($response['validationErrors'])) {
                $model->addErrors($response['validationErrors']);
                
            } else {
                throw new NotSupportedException('Unknown response: ' . json_decode($response));
            }
        }
        
        return $this->render($this->action->id, [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing User model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id, 'groupIds');
        $model->scenario = 'update';

        if ($model->load(Yii::$app->request->post())) {
            $response = $this->repository->update($model);
            
            if (isset($response['id'])) {
                $this->redirect(['view', 'id' => $response['id']]);
                
            } elseif (isset($response['validationErrors'])) {
                $model->addErrors($response['validationErrors']);
                
            } else {
                throw new NotSupportedException('Unknown response: ' . json_decode($response));
            }
        }
            
        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing User model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    /*public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }*/

    /**
     * Finds the User model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return User the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id, $fields = null)
    {
        $model = $this->repository->view($id, $fields);
        
        if ($model) {
            return $model;
        } else {
            throw new NotFoundHttpException('The requested page does not exist.');
        }
    }
}
