<?php

namespace oms\userapi\logic;

class Encryption
{
    const METHOD = 'aes128';
    const IV_LENGTH = 16; // Size expected by cipher method
    
    private $secret;
    
    public function __construct($secret)
    {
        $this->secret = $secret;
    }
    
    public function encrypt($data)
    {
        $iv = bin2hex(openssl_random_pseudo_bytes(self::IV_LENGTH / 2)); // Divide by 2 because every byte is stored in 2 hex chars
        return $iv . openssl_encrypt($data, self::METHOD, $this->secret, 0, $iv);
    }
    
    public function decrypt($data)
    {
        $iv = substr($data, 0, self::IV_LENGTH);
        $ecrypted = substr($data, self::IV_LENGTH);
        return openssl_decrypt($ecrypted, self::METHOD, $this->secret, 0, $iv);
    }
}
