<?php

namespace oms\userapi\data;

class AuthorizationHeaderFields
{
    const TOKEN_APP = 'app';
    const TOKEN_USER = 'user';

    public $secret;
    public $timestamp;
    public $tokenType;
    public $token;
    
    /**
     * Used in server side.
     * @var string
     */
    public $signature;
    
    public function __construct(Auth $auth = null)
    {
        if (isset($auth)) {
            $this->timestamp = $auth->getTimestamp();
            $this->secret = $auth->getAppSecret();
            if ($auth->hasUserToken()) {
                $this->tokenType = self::TOKEN_USER;
                $this->token = $auth->getUserToken();

            } else {
                $this->tokenType = self::TOKEN_APP;
                $this->token = $auth->getAppToken();
            }
        }
    }
}
