<?php

namespace oms\userapi\data;

use ArrayAccess;
use Assert\Assertion;

class Auth
{
    const USER_TOKEN = 'userToken';
    const TIME_DIFF = 'timeDiff';
    
    private $appSecret;
    private $appToken;
    
    /**
     *
     * @var ArrayAccess
     */
    private $store;
    
    public function __construct($appSecret, $appToken, $store)
    {
        Assertion::notEmpty($appSecret, 'App secret is required.');
        Assertion::notEmpty($appToken, 'App token is required.');
        Assertion::string($appSecret);
        Assertion::string($appToken);
        Assertion::isArrayAccessible($store);
        
        $this->appSecret = $appSecret;
        $this->appToken = $appToken;
        $this->store = $store;
    }
    
    public function getAppSecret()
    {
        return $this->appSecret;
    }
    
    public function getAppToken()
    {
        return $this->appToken;
    }
    
    public function getTimestamp()
    {
        $diff = isset($this->store[self::TIME_DIFF]) ? $this->store[self::TIME_DIFF] : 0;
        return time() + $diff;
    }
    
    public function setTimestamp($timestamp)
    {
        $this->store[self::TIME_DIFF] = $timestamp - time();
    }
    
    public function hasUserToken()
    {
        return isset($this->store[self::USER_TOKEN]);
    }
    
    public function getUserToken()
    {
        return isset($this->store[self::USER_TOKEN]) ? $this->store[self::USER_TOKEN] : null;
    }
    
    public function setUserToken($token)
    {
        $this->store[self::USER_TOKEN] = $token;
    }
}
