<?php

namespace oms\userapi\logic;

use oms\userapi\data\AuthorizationHeaderFields;
use Psr\Http\Message\RequestInterface;

class AuthorizationHeader
{
    const NAME = 'Authorization';
    
    const HEADER_TEMPLATE = 'OMS timestamp="{timestamp}" {tokenType}="{token}" signature="{signature}"';
    const SIGNATURE_TEMPLATE = '{timestamp}\t{tokenType}\t{token}\t{secret}\n{method}\t{url}\n{body}"';
    
    const HASH_ALGO = 'sha256';
    
    private $fields;
    private $request;
    
    public function __construct(AuthorizationHeaderFields $fields, RequestInterface $request) {
        $this->fields = $fields;
        $this->request = $request;
    }
    
    public function getSignature()
    {
        $signatureString = strtr(self::SIGNATURE_TEMPLATE, [
            '{timestamp}' => $this->fields->timestamp,
            '{tokenType}' => $this->fields->tokenType,
            '{token}' => $this->fields->token,
            '{secret}' => $this->fields->secret,
            
            '{method}' => $this->request->getMethod(),
            '{url}' => (string) $this->request->getUri(),
            '{body}' => (string) $this->request->getBody(),
        ]);
        return hash(self::HASH_ALGO, $signatureString);
    }
    
    public function getValue()
    {
        $signature = $this->getSignature();
        
        return strtr(self::HEADER_TEMPLATE, [
            '{timestamp}' => $this->fields->timestamp,
            '{tokenType}' => $this->fields->tokenType,
            '{token}' => $this->fields->token,
            '{signature}' => $signature,
        ]);
    }
    
    public function sign(RequestInterface $request)
    {
        return $request->withHeader(self::NAME, $this->getValue());
    }
}
