<?php

namespace oms\userapi\data;

use Psr\Http\Message\ResponseInterface;

class Response
{
    const HEADER_TIMESTAMP = 'X-Set-Timestamp';
    const HEADER_USER_TOKEN = 'X-Set-User-Token';
    
    /**
     *
     * @var ResponseInterface
     */
    private $response;
    
    public function __construct(ResponseInterface $response)
    {
        $this->response = $response;
    }
    
    public function body()
    {
        $body = $this->response->getBody()->getContents();
        $this->response->getBody()->rewind(); // So it will work more that one time
        return $body;
    }
    
    /**
     * Resurns response json data
     * @return mixed
     */
    public function json()
    {
        $json = json_decode($this->body(), true);
        if ($json === null) {
            throw new \Exception('Cannot parse body: ' . $this->body());
        }
        return $json;
    }
}
