<?php

namespace oms\userapi\logic;

use ArrayAccess;

class SessionStore implements ArrayAccess
{
    private $name;
    
    public function __construct($name = '')
    {
        $this->name = $name;
    }
    
    public function offsetExists($offset)
    {
        $this->start();
        return isset($_SESSION[$this->name][$offset]);
    }
    
    public function offsetGet($offset)
    {
        $this->start();
        return $_SESSION[$this->name][$offset];
    }
    
    public function offsetSet($offset, $value)
    {
        $this->start();
        $_SESSION[$this->name][$offset] = $value;
    }
    
    public function offsetUnset($offset)
    {
        $this->start();
        unset($_SESSION[$this->name][$offset]);
    }
    
    private function start()
    {
        if (session_status() !== PHP_SESSION_ACTIVE) {
            session_start();
        }
        if (!isset($_SESSION[$this->name])) {
            $_SESSION[$this->name] = [];
        }
    }
}
