<?php

namespace oms\userapi;

use GuzzleHttp\Client as GuzzleClient;

/**
 * UserApi classes factory.
 */
class UserApi
{
    const BASE_URI = 'baseUri';
    const APP_SECRET = 'appSecret';
    const APP_TOKEN = 'appToken';
    
    private static $config = [
        self::BASE_URI => 'https://login.oms.center/v2',
        self::APP_SECRET => null,
        self::APP_TOKEN => null,
        'sessionVariable' => __NAMESPACE__,
        'store' => null,
    ];
    
    public static function configure(array $config)
    {
        self::$config = array_filter($config) + self::$config;
    }
    
    /**
     * 
     * @return Client
     */
    public static function createClient()
    {
        return new Client(
            self::$config[self::BASE_URI],
            self::createAuth(),
            new GuzzleClient()
        );
    }
    
    public static function createEncryption()
    {
        return new logic\Encryption(self::$config[self::APP_SECRET]);
    }
    
    public static function createLoginEndpoints(Client $client)
    {
        return new LoginEndpoints($client, self::createEncryption());
    }
    
    private static function createAuth()
    {
        $store = isset(self::$config['store'])
            ? self::$config['store']
            : new logic\SessionStore(self::$config['sessionVariable']);
        
        return new data\Auth(
            self::$config[self::APP_SECRET],
            self::$config[self::APP_TOKEN],
            $store
        );
    }
}
