<?php

namespace oms\userapi;

use oms\userapi\logic\Encryption;

class LoginEndpoints
{
    /**
     * @var Client
     */
    private $client;
    /**
     * @var Encryption
     */
    private $encryption;
    
    public function __construct(Client $client, Encryption $encryption)
    {
        $this->client = $client;
        $this->encryption = $encryption;
    }
    
    public function login($username, $password)
    {
        $encryptedPassword = $this->encryption->encrypt($password);
        
        return $this->client->request('POST', '/auth/login', [
            'username' => $username,
            'password' => $encryptedPassword,
        ]);
    }
}
