<?php

namespace oms\contentparser;

class ContentClient
{
    public $mediaDir;
    public $imageUrl;

    private $title;
    private $body;
    private $slug;
    private $linkText;
    private $order;
    private $filename;
    private $organization;
    private $question;
    private $field;
    private $fieldType;
    private $folderAsset;

    private $parser;

    private function createParser()
    {
        $this->parser = new Parser($this->mediaDir . DIRECTORY_SEPARATOR . 'assets');
        $this->parser->setImageSrc($this->imageUrl);
    }

    public function getTemplate($templatePath)
    {
        if (!$this->parser) {
            $this->createParser();
        }
        return $this->parser->getTemplate($templatePath);
    }

    public function getAllTemplates($dirPath)
    {
        if (!is_dir($dirPath)) {
            throw new \Exception("Directory '{$dirPath}' with Meta does not exists.");
        }
        $result = [];
        foreach (new \DirectoryIterator($dirPath) as $file) {
            if ($file->isFile() && $file->getExtension() === 'md') {
                $templatePath = $dirPath . DIRECTORY_SEPARATOR . $file->getFilename();
                $result[] = $this->getTemplate($templatePath);
            }
        }
        return $result;
    }

    public function getTitle($template)
    {
        if (!$this->parser) {
            $this->createParser();
        }
        $this->title = $this->parser->getTitle($template);
        return $this->title;
    }

    public function getBody($template)
    {
        if (!$this->parser) {
            $this->createParser();
        }
        $this->body = $this->parser->getBody($template);
        return $this->body;
    }

    public function getSlug($template)
    {
        if (!$this->parser) {
            $this->createParser();
        }
        $this->slug = $this->parser->getSlug($template);
        return $this->slug;
    }

    public function getLinkText($template)
    {
        if (!$this->parser) {
            $this->createParser();
        }
        $this->linkText = $this->parser->getLinkText($template);
        return $this->linkText;
    }

    public function getOrder($template)
    {
        if (!$this->parser) {
            $this->createParser();
        }
        $this->order = $this->parser->getOrder($template);
        return $this->order;
    }

    public function getFilename($template)
    {
        if (!$this->parser) {
            $this->createParser();
        }
        $this->filename = $this->parser->getFilename($template);
        return $this->filename;
    }

    public function getQuestion($template)
    {
        if (!$this->parser) {
            $this->createParser();
        }
        $this->question = $this->parser->getQuestion($template);
        return $this->question;
    }

    public function getOrganization($template)
    {
        if (!$this->parser) {
            $this->createParser();
        }
        $this->organization = $this->parser->getOrganization($template);
        return $this->organization;
    }

    public function getField($template)
    {
        if (!$this->parser) {
            $this->createParser();
        }
        $this->field = $this->parser->getField($template);
        return $this->field;
    }

    public function getFieldType($template)
    {
        if (!$this->parser) {
            $this->createParser();
        }
        $this->fieldType = $this->parser->getFieldType($template);
        return $this->fieldType;
    }
    
    public function getFolderAsset($template)
    {
        if (!$this->parser) {
            $this->createParser();
        }
        $this->folderAsset = $this->parser->getFolderAsset($template);
        return $this->folderAsset;
    }

    public function setTitle($title)
    {
        $this->title = $title;
    }

    public function setBody($body)
    {
        $this->body = $body;
    }

    public function setSlug($slug)
    {
        $this->slug = $slug;
    }

    public function setLinkText($linkText)
    {
        $this->linkText = $linkText;
    }

    public function setOrder($order)
    {
        $this->order = $order;
    }

    public function setFilename($filename)
    {
        $this->filename = $filename;
    }

    public function setQuestion($question)
    {
        $this->question = $question;
    }

    public function setOrganization($organization)
    {
        $this->organization = $organization;
    }

    public function setField($field)
    {
        $this->field = $field;
    }

    public function setFieldType($fieldType)
    {
        $this->fieldType = $fieldType;
    }
    
    public function setFolderAsset($folderAsset)
    {
        $this->folderAsset = $folderAsset;
    }
}